##Import libraries
import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator
import numpy as np
import pandas as pd
from scipy import stats
from math import pi
import string
from PySide import QtGui
import os
from figsquare import figsquare
import itertools

plt.style.use('paper')

## select multiple files, and put filenames in a list
filenames = QtGui.QFileDialog.getOpenFileNames(None, 'Selecteer het bestand', filter = '*.lvm')[0]

print(filenames)

## data analysis
headers = ['time', 'mass']

color = itertools.cycle(('0.15', '0.3', '0.5','0.7'))

plt.close('all')
plt.figure(1,figsize=(80/25.4,80/25.4))

for filename in filenames:
    #read data and plot raw data
    data = pd.read_csv(filename, sep='\t', header=0, names=headers)
    data = data-data.iloc[0]
    time_hr = (data['time']*5)/3600
    plt.plot(time_hr,data['mass'],'--',color=next(color))

plt.xlabel('Time (h)')
plt.ylabel('Permeate mass (g)')
plt.xlim(0,40)
plt.ylim(-0.05,1.05)
  
ax = plt.gca()
ax.xaxis.set_major_locator(MultipleLocator(10))
ax.yaxis.set_major_locator(MultipleLocator(0.5))
ax.yaxis.set_minor_locator(MultipleLocator(0.25))

plt.text(30,0.92,'0.011\nLMH/bar',fontsize=9)
plt.text(30.1,0.40,'0.007\nLMH/bar',fontsize=9)
plt.text(28,0.19,'0.004\nLMH/bar',fontsize=9)


figsquare()

plt.savefig('zero_permeation_ethanol.pdf')